const router = require("express").Router();
const fs = require("fs");
const SESSION_FILE_PATH = "./session.json";

router.get("/checkauth", async (req, res) => {
  client
    .getState()
    .then((data) => {
      console.log(data);
      res.send(data);
    })
    .catch((err) => {
      if (err) {
        res.send("DISCONNECTED");
        try {
          fs.unlinkSync(SESSION_FILE_PATH);
        } catch (err) {
          console.log(err);
        }
      }
    });
});
router.get("/logout", async (req, res) => {
  client
    .destroy()
    .then(() => {
      fs.unlinkSync(SESSION_FILE_PATH, function (err) {
        if (err) return console.log(err);
        console.log("Session file deleted!");
      });
    })
    .catch((err) => {
      console.log(err);
    });
});

router.get("/getqr", (req, res) => {
  var qrjs = fs.readFileSync("components/qrcode.js");
  fs.readFile("components/last.qr", (err, last_qr) => {
    fs.readFile("session.json", (serr, sessiondata) => {
      if (err && sessiondata) {
        res.write("<html><body><h2>Already Authenticated</h2></body></html>");
        res.end();
      } else if (!err && serr) {
        var page = `
                    <html>
                        <body>
                            <script>${qrjs}</script>
                            <div id="qrcode"></div>
                            <script type="text/javascript">
                                new QRCode(document.getElementById("qrcode"), "${last_qr}");
                            </script>
                        </body>
                    </html>
                `;
        res.write(page);
        res.end();
      }
    });
    if (err) {
    } else {
    }
  });
});
module.exports = router;
